
IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL') 
BEGIN

	CREATE TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL](
		[CD_CTR] [int] NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
	 CONSTRAINT [PK_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC,
		[CD_EMP] ASC,
		[CD_FILIAL] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL] ADD  CONSTRAINT [DF_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

	ALTER TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL] ADD  CONSTRAINT [DF_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL] ADD  CONSTRAINT [DF_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL]  WITH CHECK ADD  CONSTRAINT [FK_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL_PRC_FILIAL_GRP_PERSONALIZAVEIS] FOREIGN KEY([CD_EMP], [CD_FILIAL])
	REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL] CHECK CONSTRAINT [FK_PRC_FILIAL_GRP_PERSONALIZAVEIS_CPL_PRC_FILIAL_GRP_PERSONALIZAVEIS]
END


